/**
 * Battle Coach - Blindspot Weights
 * Boost actions that new players commonly miss
 * 
 * All weights are multipliers: 1.0 = no change, >1.0 = boosted, <1.0 = penalized
 */

const BLINDSPOT_WEIGHTS = {
  // SWITCHING - Most undervalued category for new players
  SWITCH_AVOID_SUPER_EFFECTIVE: 1.45,
  SWITCH_INTO_INTIMIDATE: 1.40,
  SWITCH_BETTER_MATCHUP: 1.25,
  SWITCH_OUT_BURNED_PHYSICAL: 1.40,
  SWITCH_OUT_PARALYZED: 1.30,
  SWITCH_PRESERVE_WIN_CON: 1.55,
  PIVOT_ADVANTAGE: 1.25,
  
  // PROTECT - Context-dependent
  PROTECT_DOUBLE_TARGETED: 1.45,
  PROTECT_STALL_SPEED_CONTROL: 1.35,
  PROTECT_ENABLE_PARTNER: 1.30,
  PROTECT_READ_DOUBLE_UP: 1.25,
  PROTECT_WASTEFUL: 0.70,
  
  // SPEED CONTROL - Most impactful category new players miss
  TAILWIND_TURN_ONE: 1.45,
  TRICK_ROOM_VS_FAST: 1.50,
  SPREAD_SPEED_DROP: 1.30,
  PARALYZE_THREAT: 1.35,
  
  // OFFENSIVE PLAYS
  TARGET_KO_RANGE: 1.40,
  SUPER_EFFECTIVE: 1.20,
  HELPING_HAND_FOR_KO: 1.35,
  FOCUS_OPPONENT_WIN_CON: 1.45,
  SPREAD_BOTH_DAMAGED: 1.20,
  ATTACK_INTO_PROTECT: 0.65,
  DOUBLE_INTO_SWITCH: 0.75,
  
  // DEFENSIVE / DISRUPTION
  FAKE_OUT_DENY: 1.50,
  TAUNT_SUPPORT: 1.40,
  REDIRECT_PROTECT_PARTNER: 1.35,
  WIDE_GUARD_VS_SPREAD: 1.30,
  QUICK_GUARD_VS_PRIORITY: 1.25,
  
  // STRATEGIC / POSITIONAL
  DENY_SETUP: 1.45,
  REMOVE_TR_SETTER: 1.50,
  REMOVE_TAILWIND_SETTER: 1.40,
  PLAY_AROUND_INTIMIDATE: 1.25,
  
  // TERA
  TERA_SURVIVE_KO: 1.40,
  TERA_BOOST_KO: 1.30,
  TERA_WASTEFUL: 0.80,
  
  // WIN CONDITION
  PRESERVE_WIN_CON: 1.55,
  ENABLE_WIN_CON: 1.50,
  REMOVE_WIN_CON_CHECK: 1.45,
};

function getWeight(key) {
  return BLINDSPOT_WEIGHTS[key] || 1.0;
}

function applyWeights(keys) {
  let mult = 1.0;
  for (const key of keys) {
    mult *= getWeight(key);
  }
  return mult;
}

// Expose to global scope
window.BlindspotWeights = {
  BLINDSPOT_WEIGHTS,
  getWeight,
  applyWeights
};
